// 2003/03/18 Appli.cs
// Copyright (C) Ortana<ortaclient@hotmail.com>
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


using System;
using System.Windows.Forms;

using NTF.HXD;
using NTF.HXD.DOC;

namespace NTF.HXD
{
	/// <summary>
	/// AvP[VNXB
	/// AvP[V̊NX𓝍AǗB
	/// </summary>
	public class Appli
	{
		
		SettingManager setting;

		/// <summary>
		/// ݒB
		/// </summary>
		public SettingManager Setting
		{
			get{return setting;}
		}

		public Config ServerConfig
		{
			get{return setting.ServerConfig;}
		}

		public AppConfigManager AppConfig
		{
			get{return setting.AppConfig;}
		}

		BootManager hxdBootManager;
		public BootManager HXDBootManager
		{
			get{return hxdBootManager;}
		}

		NTF.DOC.FileWatcher watcher = new NTF.DOC.FileWatcher(Application.StartupPath);
		public NTF.DOC.FileWatcher FileWatcher
		{
			get{return watcher;}
		}

		public Appli()
		{
			setting = new SettingManager(this);
			setting.Load();

			hxdBootManager = new BootManager(this);
		}
	}
}
